/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import com.gjhi.tinkersinnovation.library.hooks.ModifyDamageSourceModifierHook;
import com.gjhi.tinkersinnovation.library.modifiers.OverImitateArmorModifier;
import com.gjhi.tinkersinnovation.library.modifiers.OverImitateModifier;
import com.gjhi.tinkersinnovation.register.TinkersInnovationCompat;
import com.gjhi.tinkersinnovation.register.TinkersInnovationHooks;
import com.gjhi.tinkersinnovation.register.TinkersInnovationMaterials;
import com.gjhi.tinkersinnovation.register.TinkersInnovationModifiers;
import com.gjhi.tinkersinnovation.register.TinkersInnovationSlots;
import com.gjhi.tinkersinnovation.register.TinkersInnovationUtils;
import dev.xkmc.l2hostility.content.logic.DifficultyLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.DamageBlockModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.ModifyDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.RepairFactorModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.DamageDealtModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.modifiers.slotless.OverslimeModifier;

public class OmnipotentModifier
extends Modifier
implements VolatileDataModifierHook,
MeleeDamageModifierHook,
ToolStatsModifierHook,
MeleeHitModifierHook,
ProjectileHitModifierHook,
ConditionalStatModifierHook,
BreakSpeedModifierHook,
ToolDamageModifierHook,
OnAttackedModifierHook,
ModifyDamageModifierHook,
DamageDealtModifierHook,
DamageBlockModifierHook,
InventoryTickModifierHook,
ModifyDamageSourceModifierHook,
RepairFactorModifierHook,
TooltipModifierHook,
AttributesModifierHook {
    private static final String[] list = new String[]{TinkersInnovationMaterials.polychrome_alloy.toString(), TinkersInnovationMaterials.slimton.toString(), TinkersInnovationMaterials.shulkerate.toString(), TinkersInnovationMaterials.sculkium.toString(), TinkersInnovationMaterials.eternium.toString(), TinkersInnovationMaterials.decline.toString(), TinkersInnovationMaterials.miracle.toString(), TinkersInnovationMaterials.hostilium.toString(), TinkersInnovationMaterials.clonate.toString(), TinkersInnovationMaterials.sunsoul_alloy.toString(), MaterialIds.manyullyn.toString(), MaterialIds.queensSlime.toString(), MaterialIds.hepatizon.toString(), MaterialIds.ancientHide.toString(), MaterialIds.blazingBone.toString(), MaterialIds.blazewood.toString(), MaterialIds.enderslimeVine.toString(), "tinkerscalibration:mangobberslime", "tinkerscalibration:mandite", "tinkerscalibration:darkmatter", "tinkerscalibration:redmatter", "tinkerscalibration:emperorslime", "tinkerscalibration:netherite", "tinkerscalibration:bnetherite", "tinkerscalibration:fnetherite", "tinkerscalibration:gnetherite", "tinkerscalibration:wnetherite", "tinkerscalibration:snetherite", "tinkerscalibration:pnetherite", "tinkerscalibration:prnetherite", "tinkerscalibration:enetherite", "tinkerscalibration:fazelle", "tinkerscalibration:breashell", "tinkerscalibration:gobbernether", "tinkerscalibration:oraclium", "tinkerscalibration:soulgold", "tinkerscalibration:jazz", "tinkerscalibration:wither", "tinkerscalibration:gravity", "tinkerscalibration:lindsteel", "tinkers_thinking:stewium", "tinkers_ingenuity:bedrock_alloy_material", "tinkers_ingenuity:blood_binding_material", "tinkers_ingenuity:blood_steel_material", "tinkers_ingenuity:blue_sky_material", "tinkers_ingenuity:crocell_material", "tinkers_ingenuity:crystal_matrix_material", "tinkers_ingenuity:dye_fire_material", "tinkers_ingenuity:etherium_material", "tinkers_ingenuity:evil_material", "tinkers_ingenuity:fire_steel_material", "tinkers_ingenuity:gaia_material", "tinkers_ingenuity:glasya_material", "tinkers_ingenuity:gleiter_material", "tinkers_ingenuity:ice_steel_material", "tinkers_ingenuity:ignitium_material", "tinkers_ingenuity:infinity_material", "tinkers_ingenuity:knight_crystal_material", "tinkers_ingenuity:lighting_steel_material", "tinkers_ingenuity:neutronium_material", "tinkers_ingenuity:ocean_alloy_material", "tinkers_ingenuity:prince_slime_material", "tinkers_ingenuity:sea_dream_material", "tinkers_ingenuity:shine_alloy_material", "tinkers_ingenuity:shine_gold_material", "tinkers_ingenuity:simir_material", "tinkers_ingenuity:sunlit_material", "tinkers_ingenuity:teslin_alloy_material", "tinkers_ingenuity:twilight_material", "tinkers_ingenuity:xuan_ming_material", "tinkers_ingenuity:zesley_material"};
    private String PATH = "tooltip.tinkersinnovation.omnipotent.material.";

    public int getPriority() {
        return 20;
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.MELEE_DAMAGE, ModifierHooks.MELEE_HIT, ModifierHooks.PROJECTILE_HIT, ModifierHooks.TOOL_STATS, ModifierHooks.VOLATILE_DATA, ModifierHooks.CONDITIONAL_STAT, ModifierHooks.BREAK_SPEED, ModifierHooks.TOOL_DAMAGE, ModifierHooks.ON_ATTACKED, ModifierHooks.MODIFY_DAMAGE, ModifierHooks.DAMAGE_DEALT, ModifierHooks.DAMAGE_BLOCK, ModifierHooks.INVENTORY_TICK, TinkersInnovationHooks.MODIFY_SOURCE, ModifierHooks.REPAIR_FACTOR, ModifierHooks.ATTRIBUTES});
    }

    public float getRepairFactor(IToolStackView tool, ModifierEntry entry, float factor) {
        int partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:lindsteel");
        if (partnum > 0) {
            factor += 0.25f * (float)entry.getLevel() * (float)partnum;
        }
        return factor;
    }

    @Override
    public void modifyDamageSource(IToolStackView tool, ModifierEntry modifier, LivingEntity attacker, LivingEntity target, DamageSource source) {
        if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:darkmatter", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED) > 0) {
            source.m_238403_();
        }
        if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:redmatter", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED) > 0) {
            source.m_19382_();
        }
    }

    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        int partnum;
        LivingEntity target = context.getLivingTarget();
        Player player = context.getPlayerAttacker();
        if (player != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:etherium_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0 && player.f_19853_.m_46472_().equals((Object)Level.f_46428_)) {
            knockback += (float)partnum;
        }
        if (player != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:sea_dream_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, partnum * 100, modifier.getLevel() - 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, partnum * 100, modifier.getLevel() - 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, partnum * 100, modifier.getLevel() - 1));
        }
        return knockback;
    }

    public void afterMeleeHit(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        int partnum;
        LivingEntity target = context.getLivingTarget();
        LivingEntity player = context.getAttacker();
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, MaterialIds.blazingBone.toString(), TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            target.m_20254_(5 * partnum * modifier.getLevel());
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:blood_steel_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0 && (double)RANDOM.nextFloat() > 0.1 * (double)partnum * (double)modifier.getLevel()) {
            tool.setDamage(Math.max(0, tool.getDamage() - 1));
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:breashell", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 20 * partnum));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 40 * partnum));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 20 * partnum));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 40 * partnum));
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:blue_sky_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0 && !player.m_20096_()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 20 * partnum));
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:shine_gold_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 100 * partnum, modifier.getLevel() - 1));
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:simir_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 100 * partnum, modifier.getLevel() - 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 100 * partnum, modifier.getLevel() - 1));
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:teslin_alloy_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 100 * partnum, modifier.getLevel() - 1));
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:soulgold", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100 * partnum, modifier.getLevel() - 1));
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:wither", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0 && RANDOM.nextFloat() < 0.1f * (float)modifier.getLevel()) {
            player.f_19802_ = 20 * partnum;
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:sunlit_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0 && player.f_19853_.m_46461_() && player.f_19853_.m_45527_(player.m_20183_()) && !player.f_19853_.m_46471_() && !player.f_19853_.m_46470_() && target != null) {
            target.m_6469_(DamageSource.f_19319_, damageDealt * 0.1f);
        }
        if (target != null && OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:mandite", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED) > 0) {
            target.f_19802_ = 0;
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:crocell_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0 && target != null && (double)damageDealt < 0.05 * (double)partnum * (double)modifier.getLevel() * (double)target.m_21233_()) {
            player.m_5634_(5.0f);
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:evil_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0 && (target instanceof Shulker || target instanceof EnderMan)) {
            target.m_6074_();
        }
        partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:fire_steel_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED);
        partnum += OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:ice_steel_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED);
        if (target != null && (partnum += OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:lighting_steel_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19602_));
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.sculkium.toString(), TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            List<LivingEntity> entities = TinkersInnovationUtils.getLivingEntitiesInRange((Entity)target, modifier.getLevel() + 1, false);
            entities.remove(player);
            for (LivingEntity entity : entities) {
                target.m_6469_(DamageSource.m_216876_((Entity)entity), (float)(2 * partnum));
            }
        }
        if (target != null && OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.sunsoul_alloy.toString(), TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED) > 0) {
            target.m_20254_(3 + target.m_20094_() / 20);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.clonate.toString(), TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            OverImitateModifier imitate = (OverImitateModifier)TinkersInnovationModifiers.over_imitate.get();
            imitate.modifyImitateDamage(tool.getPersistentData(), 1.0f + (float)modifier.getLevel() * 0.5f);
        }
    }

    public int onDamageTool(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, int amount, @Nullable LivingEntity player) {
        int partnum;
        if (player != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:fazelle")) > 0) {
            player.m_7910_(player.m_6113_() + player.m_6113_() * (float)modifier.getLevel() * (float)partnum * 0.1f);
        }
        if (player != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:blood_binding_material")) > 0 && (double)RANDOM.nextFloat() < 0.1 * (double)partnum * (double)modifier.getLevel()) {
            player.m_5634_(1.0f);
        }
        if (player != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:prince_slime_material")) > 0) {
            OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
            if ((double)RANDOM.nextFloat() < 0.8 * ((double)overslime.getShield(tool) / (double)overslime.getShield(tool))) {
                overslime.addOverslime(tool, modifier, 2 * partnum);
            }
        }
        if (player != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:neutronium_material")) > 0 && (double)RANDOM.nextFloat() < 0.75) {
            return 0;
        }
        return amount;
    }

    public void addToolStats(@NotNull IToolContext context, @NotNull ModifierEntry modifier, @NotNull ModifierStatsBuilder builder) {
        int partnum = OmnipotentModifier.getMaterialCount(context, MaterialIds.manyullyn.toString());
        if (partnum > 0) {
            ToolStats.ACCURACY.add(builder, 0.15 * (double)modifier.getLevel() * (double)partnum);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(context, MaterialIds.hepatizon.toString())) > 0) {
            ToolStats.DRAW_SPEED.multiply(builder, (double)(1.0f + (float)(modifier.getLevel() * partnum) * 0.12f));
            ToolStats.MINING_SPEED.multiply(builder, (double)(1.0f + (float)(modifier.getLevel() * partnum) * 0.12f));
            ToolStats.KNOCKBACK_RESISTANCE.multiply(builder, (double)(1.0f + (float)(modifier.getLevel() * partnum) * 0.12f));
            ToolStats.ARMOR_TOUGHNESS.multiply(builder, (double)(1.0f + (float)(modifier.getLevel() * partnum) * 0.12f));
        }
        if (OmnipotentModifier.getMaterialCount(context, MaterialIds.ancientHide.toString()) > 0) {
            ToolStats.VELOCITY.add(builder, (double)modifier.getLevel() * 0.5);
            ToolStats.MINING_SPEED.add(builder, (double)modifier.getLevel() * 0.5);
            ToolStats.ATTACK_DAMAGE.add(builder, (double)modifier.getLevel() * 1.5);
            ToolStats.ARMOR_TOUGHNESS.add(builder, (double)(modifier.getLevel() * 3));
        }
        if (OmnipotentModifier.getMaterialCount(context, MaterialIds.enderslimeVine.toString(), TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED) > 0) {
            ToolStats.VELOCITY.multiply(builder, 1.0 + (double)modifier.getLevel() * 0.15);
            ToolStats.MINING_SPEED.multiply(builder, 1.0 + (double)modifier.getLevel() * 0.15);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(context)) > 0) {
            ToolStats.DURABILITY.add(builder, (double)(modifier.getLevel() * partnum * 100));
            ToolStats.ATTACK_DAMAGE.add(builder, (double)(modifier.getLevel() * partnum));
            ToolStats.PROJECTILE_DAMAGE.add(builder, (double)(modifier.getLevel() * partnum) * 0.5);
            ToolStats.ARMOR.add(builder, (double)(modifier.getLevel() * partnum * 2));
            ToolStats.ARMOR_TOUGHNESS.add(builder, (double)(modifier.getLevel() * partnum));
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(context, "tinkers_ingenuity:gaia_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            ToolStats.ATTACK_SPEED.multiply(builder, 1.0 + 0.25 * (double)modifier.getLevel());
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(context, "tinkers_ingenuity:glasya_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            ToolStats.ATTACK_DAMAGE.multiply(builder, 1.0 + 0.2 * (double)partnum);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(context, "tinkers_ingenuity:gleiter_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            ToolStats.ATTACK_DAMAGE.multiply(builder, 1.0 + 0.2 * (double)partnum);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(context, "tinkers_ingenuity:twilight_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            ToolStats.ATTACK_SPEED.add(builder, 0.5);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(context, MaterialIds.queensSlime.toString())) > 0) {
            OverslimeModifier.OVERSLIME_STAT.add(builder, (double)(200 * partnum * modifier.getLevel()));
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(context, "tinkerscalibration:emperorslime")) > 0) {
            OverslimeModifier.OVERSLIME_STAT.multiply(builder, 1.0 + 0.2 * (double)modifier.getLevel() * (double)partnum);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(context, "tinkerscalibration:mandite")) > 0) {
            ToolStats.DRAW_SPEED.multiply(builder, 1.0 + 0.15 * (double)modifier.getLevel() * (double)partnum);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(context, TinkersInnovationMaterials.shulkerate.toString())) > 0) {
            ToolStats.DURABILITY.add(builder, (double)(200 * modifier.getLevel() * partnum));
            ToolStats.ATTACK_DAMAGE.add(builder, (double)(modifier.getLevel() * partnum));
            ToolStats.VELOCITY.multiply(builder, 1.0 + 0.1 * (double)modifier.getLevel() * (double)partnum);
            ToolStats.PROJECTILE_DAMAGE.add(builder, 0.5 * (double)modifier.getLevel() * (double)partnum);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(context, TinkersInnovationMaterials.sculkium.toString())) > 0) {
            ToolStats.VELOCITY.multiply(builder, 1.0 + 0.2 * (double)modifier.getLevel() * (double)partnum);
        }
        partnum = OmnipotentModifier.getMaterialCount(context, "tinkers_ingenuity:fire_steel_material");
        partnum += OmnipotentModifier.getMaterialCount(context, "tinkers_ingenuity:ice_steel_material");
        if ((partnum += OmnipotentModifier.getMaterialCount(context, "tinkers_ingenuity:lighting_steel_material")) > 0) {
            ToolStats.ATTACK_DAMAGE.add(builder, (double)(modifier.getLevel() * partnum * 2));
            ToolStats.PROJECTILE_DAMAGE.add(builder, (double)(modifier.getLevel() * partnum));
            ToolStats.ARMOR.add(builder, (double)(modifier.getLevel() * partnum * 2));
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(context, "tinkers_ingenuity:bedrock_alloy_material")) > 0) {
            ToolStats.DURABILITY.multiply(builder, 2.0);
            ToolStats.ATTACK_DAMAGE.multiply(builder, 1.2);
        }
    }

    public float modifyStat(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        int partnum = OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.slimton.toString(), TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED);
        if (partnum > 0) {
            float current = overslime.getShield(tool);
            if (stat == ToolStats.PROJECTILE_DAMAGE) {
                return (float)((double)baseValue + Math.sqrt(current) * (double)modifier.getLevel() * (double)partnum * 0.01 * (double)tool.getMultiplier((INumericToolStat)ToolStats.PROJECTILE_DAMAGE));
            }
        }
        return baseValue;
    }

    public void onBreakSpeed(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, PlayerEvent.BreakSpeed event, @NotNull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Player player = event.getEntity();
        int partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:netherite", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST);
        partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:bnetherite", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST);
        partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:fnetherite", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST);
        partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:gnetherite", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST);
        partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:wnetherite", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST);
        partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:snetherite", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST);
        partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:pnetherite", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST);
        partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:prnetherite", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST);
        if ((partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:enetherite", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST)) > 0 && player != null && player.m_20186_() < 64.0) {
            event.setNewSpeed((float)((double)event.getNewSpeed() + (double)(event.getNewSpeed() * (float)partnum * (float)modifier.getLevel()) * 0.01 * (64.0 - player.m_20186_())));
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:etherium_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST)) > 0 && player != null && player.f_19853_.m_46472_().equals((Object)Level.f_46428_)) {
            event.setNewSpeed(event.getNewSpeed() + event.getNewSpeed() * 0.5f * (float)partnum);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:shine_alloy_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST)) > 0 && player != null && player.f_19853_.m_46461_()) {
            event.setNewSpeed(event.getNewSpeed() + event.getNewSpeed() * 0.1f * (float)partnum * (float)modifier.getLevel());
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:zesley_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST)) > 0 && player != null) {
            float num = (player.m_21233_() - player.m_21223_()) / 2.0f;
            event.setNewSpeed(event.getNewSpeed() + event.getNewSpeed() * Math.min(0.75f, 0.075f * num) * (float)partnum);
        }
    }

    public float getMeleeDamage(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        int partnum;
        LivingEntity target = context.getLivingTarget();
        LivingEntity attacker = context.getAttacker();
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, MaterialIds.manyullyn.toString(), TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            damage += (target.m_21233_() - target.m_21223_()) * (0.1f + 0.05f * (float)modifier.getLevel() * (float)partnum);
        }
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        partnum = OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.slimton.toString(), TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED);
        if (partnum > 0) {
            float current = overslime.getShield(tool);
            damage += (float)(Math.sqrt(current) * (double)modifier.getLevel() * (double)partnum * 0.01 * (double)damage);
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, MaterialIds.blazingBone.toString(), TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0 && target.m_6060_()) {
            damage *= 1.2f;
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:knight_crystal_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            damage += (attacker.m_21233_() - attacker.m_21223_()) * (0.25f * (float)modifier.getLevel() * (float)partnum);
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:gravity", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            damage += target.f_19789_ * (float)partnum;
            damage += attacker.f_19789_ * (float)partnum;
            attacker.m_183634_();
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:jazz", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            damage += damage * RANDOM.nextFloat();
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:crystal_matrix_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0 && tool.getDamage() * 2 > tool.getCurrentDurability()) {
            damage += damage * 0.2f * (float)partnum;
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:ocean_alloy_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0 && target.m_20072_()) {
            damage += damage * 0.2f * (float)partnum;
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:dye_fire_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0 && (target.m_6060_() || target.m_20071_())) {
            damage += (float)(3 * partnum);
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:ignitium_material", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0 && target.m_6060_()) {
            damage += (float)(4 * partnum * modifier.getLevel());
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:oraclium", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0) {
            for (MobEffectInstance instance : target.m_21220_()) {
                if (!instance.m_19544_().m_19483_().equals((Object)MobEffectCategory.HARMFUL)) continue;
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (ItemStack stack : instance.getCurativeItems()) {
                    if (stack.m_41720_().equals(Items.f_42455_)) continue;
                    list.add(stack);
                }
                instance.setCurativeItems(list);
            }
        }
        if (target != null && OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:mandite", TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED) > 0) {
            target.f_19802_ = 0;
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.decline.toString(), TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0 && target != null) {
            MobEffectInstance effect = target.m_21124_(MobEffects.f_19615_);
            if (effect != null) {
                damage += (float)(2 * partnum * modifier.getLevel() * (effect.m_19564_() + 1));
            }
            if (target instanceof WitherSkeleton) {
                damage += (float)(2 * partnum * modifier.getLevel());
            }
            if (target instanceof WitherBoss) {
                damage += (float)(4 * partnum * modifier.getLevel());
            }
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.hostilium.toString(), TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.RANGED)) > 0 && TinkersInnovationCompat.L2Hostility.isLoaded()) {
            damage += (float)DifficultyLevel.ofAny((LivingEntity)attacker) * damage * 0.02f * (float)partnum * (float)modifier.getLevel();
        }
        return damage;
    }

    public void addVolatileData(@NotNull IToolContext context, @NotNull ModifierEntry modifier, @NotNull ModDataNBT volatileData) {
        int partnum = OmnipotentModifier.getMaterialCount(context, "tinkerscalibration:mangobberslime");
        if (partnum > 0) {
            volatileData.addSlots(SlotType.ABILITY, partnum * modifier.getLevel());
            volatileData.addSlots(SlotType.UPGRADE, partnum * modifier.getLevel());
            if (context.hasTag(TinkerTags.Items.ARMOR)) {
                volatileData.addSlots(SlotType.DEFENSE, partnum * modifier.getLevel());
            }
        }
        if (OmnipotentModifier.getMaterialCount(context, "tinkerscalibration:gobbernether") > 0) {
            volatileData.addSlots(SlotType.ABILITY, 1);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(context, TinkersInnovationMaterials.eternium.toString())) > 0) {
            volatileData.addSlots(SlotType.UPGRADE, partnum);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(context, TinkersInnovationMaterials.miracle.toString())) > 0) {
            volatileData.addSlots(TinkersInnovationSlots.HOSTILITY, partnum * modifier.getLevel());
        }
        if (OmnipotentModifier.getMaterialCount(context, "tinkers_ingenuity:infinity_material") > 0) {
            volatileData.addSlots(SlotType.ABILITY, 2);
        }
    }

    public void onAttacked(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, @NotNull EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        int partnum;
        LivingEntity wearer = context.getEntity();
        LivingEntity target = null;
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2;
            target = entity2 = (LivingEntity)entity;
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:blue_sky_material", TinkerTags.Items.ARMOR)) > 0) {
            wearer.m_183634_();
            if (target != null) {
                target.f_19789_ *= 1.5f;
            }
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:knight_crystal_material", TinkerTags.Items.ARMOR)) > 0) {
            wearer.m_7911_(wearer.m_6103_() + (float)(4 * partnum));
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:simir_material", TinkerTags.Items.ARMOR)) > 0) {
            wearer.m_7911_(wearer.m_6103_() + (float)(4 * partnum));
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, MaterialIds.blazewood.toString(), TinkerTags.Items.ARMOR)) > 0 && target != null) {
            target.m_20254_(5 * modifier.getLevel() * partnum);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:sunlit_material", TinkerTags.Items.ARMOR)) > 0 && (double)RANDOM.nextFloat() < 0.1 * (double)partnum * (double)modifier.getLevel()) {
            wearer.m_20254_(10);
            if (target != null) {
                target.m_20254_(10);
            }
        }
        if (target != null && OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:oraclium", TinkerTags.Items.ARMOR) > 0) {
            for (MobEffectInstance instance : target.m_21220_()) {
                if (!instance.m_19544_().m_19483_().equals((Object)MobEffectCategory.HARMFUL)) continue;
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (ItemStack stack : instance.getCurativeItems()) {
                    if (stack.m_41720_().equals(Items.f_42455_)) continue;
                    list.add(stack);
                }
                instance.setCurativeItems(list);
            }
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:teslin_alloy_material", TinkerTags.Items.ARMOR)) > 0 && (double)RANDOM.nextFloat() < 0.1 * (double)partnum * (double)modifier.getLevel()) {
            tool.setDamage(tool.getDamage() - 10);
        }
        if (target != null && OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.sunsoul_alloy.toString(), TinkerTags.Items.ARMOR) > 0) {
            target.m_20254_(3 + target.m_20094_() / 20);
        }
    }

    public void onDamageDealt(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, @NotNull LivingEntity target, DamageSource source, float amount, boolean isDirectDamage) {
        LivingEntity wearer = context.getEntity();
        int partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:crocell_material", TinkerTags.Items.ARMOR);
        if (partnum > 0 && (double)amount < 0.05 * (double)partnum * (double)modifier.getLevel() * (double)target.m_21233_()) {
            wearer.m_5634_(5.0f);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:shine_gold_material", TinkerTags.Items.ARMOR)) > 0) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 100 * partnum, modifier.getLevel() - 1));
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:soulgold", TinkerTags.Items.ARMOR)) > 0) {
            wearer.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100 * partnum, modifier.getLevel() - 1));
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:wither", TinkerTags.Items.ARMOR)) > 0 && RANDOM.nextFloat() < 0.1f * (float)modifier.getLevel()) {
            wearer.f_19802_ = 20 * partnum;
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.clonate.toString(), TinkerTags.Items.ARMOR)) > 0) {
            OverImitateArmorModifier imitate = (OverImitateArmorModifier)TinkersInnovationModifiers.over_imitate_armor.get();
            imitate.modifyImitateArmor(tool.getPersistentData(), 1.0f + (float)modifier.getLevel() * 0.5f);
            imitate.modifyImitateToughness(tool.getPersistentData(), 1.0f + (float)modifier.getLevel() * 0.5f);
        }
    }

    public boolean isDamageBlocked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount) {
        LivingEntity wearer = context.getEntity();
        int partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:dye_fire_material", TinkerTags.Items.ARMOR);
        if (partnum > 0) {
            return source.m_19384_();
        }
        partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:redmatter", TinkerTags.Items.ARMOR);
        if (partnum > 0) {
            return (double)RANDOM.nextFloat() < 0.2;
        }
        partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:darkmatter", TinkerTags.Items.ARMOR);
        if (partnum > 0) {
            return (double)RANDOM.nextFloat() < 0.1;
        }
        return false;
    }

    public float modifyDamageTaken(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        LivingEntity wearer = context.getEntity();
        LivingEntity target = null;
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2;
            target = entity2 = (LivingEntity)entity;
        }
        int partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:netherite", TinkerTags.Items.ARMOR);
        partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:bnetherite", TinkerTags.Items.ARMOR);
        partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:fnetherite", TinkerTags.Items.ARMOR);
        partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:gnetherite", TinkerTags.Items.ARMOR);
        partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:wnetherite", TinkerTags.Items.ARMOR);
        partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:snetherite", TinkerTags.Items.ARMOR);
        partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:pnetherite", TinkerTags.Items.ARMOR);
        partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:prnetherite", TinkerTags.Items.ARMOR);
        if ((partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:enetherite", TinkerTags.Items.ARMOR)) > 0 && source.m_19384_()) {
            amount /= 2.0f;
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkersinnovation:slimton", TinkerTags.Items.ARMOR)) > 0 && (double)(wearer.m_21223_() / wearer.m_21233_()) < 0.2 * (double)partnum) {
            amount /= 2.0f;
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, MaterialIds.manyullyn.toString(), TinkerTags.Items.ARMOR)) > 0) {
            amount -= (target.m_21233_() - target.m_21223_()) * (0.1f + 0.05f * (float)modifier.getLevel() * (float)partnum);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:jazz", TinkerTags.Items.ARMOR)) > 0 && (double)(amount / wearer.m_21233_()) > 0.4 / (double)(partnum * modifier.getLevel())) {
            amount = wearer.m_21233_() * 0.4f / (float)(partnum * modifier.getLevel());
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.sculkium.toString(), TinkerTags.Items.ARMOR)) > 0 && target instanceof Warden) {
            amount /= 2.0f;
        }
        if (target != null && (partnum = OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.decline.toString(), TinkerTags.Items.ARMOR)) > 0 && target instanceof WitherBoss) {
            amount /= 2.0f;
        }
        return Math.max(amount, 0.0f);
    }

    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        int partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:ocean_alloy_material", TinkerTags.Items.ARMOR);
        if (partnum > 0 && holder.m_20069_() && !holder.m_21023_(MobEffects.f_19608_)) {
            holder.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 20));
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:shine_alloy_material", TinkerTags.Items.ARMOR)) > 0 && world.m_46461_() && world.m_45527_(holder.m_20183_()) && !world.m_46471_() && !world.m_46470_() && (double)RANDOM.nextFloat() < 0.005) {
            holder.m_5634_((float)partnum);
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_ingenuity:xuan_ming_material", TinkerTags.Items.ARMOR)) > 0 && holder.m_21233_() == holder.m_21223_() && (double)RANDOM.nextFloat() < 0.005) {
            tool.setDamage(Math.max(0, tool.getDamage() - partnum));
        }
        if ((partnum = OmnipotentModifier.getMaterialCount(tool, "tinkers_thinking:stewium")) > 0 && (double)RANDOM.nextFloat() < 0.001) {
            OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
            overslime.addOverslime(tool, modifier, 1);
        }
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        int partnum = OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.hostilium.toString(), TinkerTags.Items.ARMOR);
        if (partnum > 0 && (TinkersInnovationUtils.isInArmorSlots(slot) || TinkersInnovationUtils.isShieldInHandSlots(tool, slot))) {
            consumer.accept(Attributes.f_22276_, new AttributeModifier(UUID.fromString("8d2ff7e1-278e-43c4-9633-b67f7dc9c51e"), Attributes.f_22276_.m_22087_(), (double)(10 * partnum * modifier.getLevel()), AttributeModifier.Operation.ADDITION));
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @javax.annotation.Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (tooltipKey.equals((Object)TooltipKey.SHIFT)) {
            if (OmnipotentModifier.getMaterialCount(tool) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "default")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, MaterialIds.manyullyn.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tconstruct.manyullyn")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, MaterialIds.hepatizon.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tconstruct.hepatizon")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, MaterialIds.queensSlime.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tconstruct.queen_slime")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, MaterialIds.ancientHide.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tconstruct.ancient_hide")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, MaterialIds.blazingBone.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tconstruct.blazing_bone")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, MaterialIds.blazewood.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tconstruct.blazing_wood")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, MaterialIds.enderslimeVine.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tconstruct.enderslime_vine")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.slimton.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkersinnovation.slimton")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.shulkerate.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkersinnovation.shulkerate")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.sculkium.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkersinnovation.sculkium")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.eternium.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkersinnovation.eternium")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.clonate.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkersinnovation.clonate")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.decline.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkersinnovation.decline")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.hostilium.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkersinnovation.hostilium")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.farseeing_alloy.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkersinnovation.farseeing_alloy")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.sunsoul_alloy.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkersinnovation.sunsoul_alloy")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.straddlite_alloy.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkersinnovation.straddlite_alloy")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.hemolymph_bone.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkersinnovation.hemolymph_bone")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, TinkersInnovationMaterials.soul_bone.toString()) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkersinnovation.soul_bone")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:mangobberslime") > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkerscalibration.mangobberslime")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:mandite") > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkerscalibration.mandite")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:darkmatter") > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkerscalibration.darkmatter")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:redmatter") > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkerscalibration.redmatter")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:emperorslime") > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkerscalibration.emperorslime")));
            }
            int partnum = OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:netherite");
            partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:bnetherite");
            partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:fnetherite");
            partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:gnetherite");
            partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:wnetherite");
            partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:snetherite");
            partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:pnetherite");
            partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:prnetherite");
            if ((partnum += OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:enetherite")) > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkerscalibration.netherites")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:fazelle") > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkerscalibration.fazelle")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:breashell") > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkerscalibration.breashell")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:gobbernether") > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkerscalibration.gobbernether")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:oraclium") > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkerscalibration.oraclium")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:soulgold") > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkerscalibration.soulgold")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:jazz") > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkerscalibration.jazz")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:wither") > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkerscalibration.wither")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:gravity") > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkerscalibration.gravity")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, "tinkerscalibration:lindsteel") > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkerscalibration.lindsteel")));
            }
            if (OmnipotentModifier.getMaterialCount(tool, "tinkers_thinking:stewium") > 0) {
                tooltip.add((Component)Component.m_237115_((String)(this.PATH + "tinkers_thinking.stewium")));
            }
        }
    }

    private static int getMaterialCount(IToolStackView tool, String id) {
        return OmnipotentModifier.getMaterialCount(tool, id, TinkerTags.Items.MODIFIABLE);
    }

    private static int getMaterialCount(IToolContext tool, String id) {
        return OmnipotentModifier.getMaterialCount(tool, id, TinkerTags.Items.MODIFIABLE);
    }

    @SafeVarargs
    private static int getMaterialCount(IToolStackView tool, String id, TagKey<Item> ... tags) {
        for (TagKey<Item> tag : tags) {
            if (!tool.hasTag(tag)) continue;
            int level = 0;
            for (MaterialVariant material : tool.getMaterials().getList()) {
                if (!material.getId().toString().equals(id)) continue;
                ++level;
            }
            return level;
        }
        return 0;
    }

    @SafeVarargs
    private static int getMaterialCount(IToolContext tool, String id, TagKey<Item> ... tags) {
        for (TagKey<Item> tag : tags) {
            if (!tool.hasTag(tag)) continue;
            int level = 0;
            for (MaterialVariant material : tool.getMaterials().getList()) {
                if (!material.getId().toString().equals(id)) continue;
                ++level;
            }
            return level;
        }
        return 0;
    }

    private static int getMaterialCount(IToolStackView tool) {
        return OmnipotentModifier.getMaterialCount(tool, TinkerTags.Items.MODIFIABLE);
    }

    private static int getMaterialCount(IToolContext tool) {
        return OmnipotentModifier.getMaterialCount(tool, TinkerTags.Items.MODIFIABLE);
    }

    @SafeVarargs
    private static int getMaterialCount(IToolStackView tool, TagKey<Item> ... tags) {
        int level = 0;
        for (TagKey<Item> tag : tags) {
            if (!tool.hasTag(tag)) continue;
            for (MaterialVariant material : tool.getMaterials().getList()) {
                if (material.get().getTier() < 4 || !OmnipotentModifier.notfind(material.getId().toString())) continue;
                ++level;
            }
            break;
        }
        return level;
    }

    @SafeVarargs
    private static int getMaterialCount(IToolContext tool, TagKey<Item> ... tags) {
        int level = 0;
        for (TagKey<Item> tag : tags) {
            if (!tool.hasTag(tag)) continue;
            for (MaterialVariant material : tool.getMaterials().getList()) {
                if (material.get().getTier() < 4 || !OmnipotentModifier.notfind(material.getId().toString())) continue;
                ++level;
            }
            break;
        }
        return level;
    }

    private static boolean notfind(String name) {
        for (String s : list) {
            if (!name.equals(s)) continue;
            return false;
        }
        return true;
    }
}

